﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="cartview.aspx.cs" Inherits="Viewcart" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <script>
        // Set the date we're counting down to
        var countDownDate = new Date("March 15, 2018 2:55:00").getTime();

        // Update the count down every 1 second
        var countdownfunction = setInterval(function () {

            // Get todays date and time
            var now = new Date().getTime();

            // Find the distance between now an the count down date
            var distance = countDownDate - now;

            // Time calculations for days, hours, minutes and seconds
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            // Output the result in an element with id="demo"
            document.getElementById("demo").innerHTML = days + "d " + hours + "h "
    + minutes + "m " + seconds + "s ";

            // If the count down is over, write some text 
            if (distance < 0) {
                clearInterval(countdownfunction);
                document.getElementById("demo").innerHTML = "EXPIRED";
            }
        }, 1000);
</script>

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
    <div class="breadcrumb-container"><div class="container"><div class="breadcrumb">
	    <a class="home" href="Default.aspx" title="Return to Home">Home</a>
		<span class="navigation-pipe" ></span><span class="navigation_page">Your shopping cart</span>
	</div></div></div>

	<div class="columns-container"><div id="columns" class="container"><div class="row"><div id="center_column" class="column col-sm-12">
	    <h1 id="cart_title" class="page-heading">Shopping-cart summary
			
            
	    </h1>
        <ul class="step clearfix" id="order_step">
	        <li class="step_current  first"><span><em>01.</em> Cart Summary</span></li>
	        <li class="step_todo second"><span><em>02.</em> Sign in</span></li>
	        <li class="step_todo third"><span><em>03.</em> Address</span></li>
	        <li class="step_todo four"><span><em>04.</em> Shopping</span></li>
	        <li id="step_end" class="step_todo last"><span><em>05.</em> Payment</span></li>
        </ul>
	    <p id="emptyCartWarning" class="alert alert-warning unvisible">Your shopping cart is empty.</p>
	    <div id="order-detail-content" class="table_block table-responsive">
		<table class="table table-bordered stock-management-on">
        <asp:GridView ID="GridView1" runat="server" DataSourceID="SqlDataSource1" 
        AutoGenerateColumns="False" DataKeyNames="Id" Width="100%">
        <Columns>
            <asp:TemplateField>
                <ItemTemplate>
                    <asp:Image ID="Image1" runat="server" Height="150px" 
                        ImageUrl='<%# Eval("image") %>' Width="150px" />
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="productname" HeaderText="productname" 
                SortExpression="productname" />
            <asp:BoundField DataField="price" HeaderText="price" SortExpression="price" />
            <asp:BoundField DataField="Quantity" HeaderText="Quantity" 
                SortExpression="Quantity" />
            <asp:BoundField DataField="Amount" HeaderText="Amount" 
                SortExpression="Amount" />
        </Columns>
        </asp:GridView>
        <asp:SqlDataSource ID="SqlDataSource1" runat="server" 
                ConnectionString="<%$ ConnectionStrings:ASPNETDBConnectionString %>" 
                SelectCommand="SELECT * FROM [CartProductView] WHERE (([Status] = @Status) AND ([CartId] = @CartId)) ORDER BY [Id] DESC">
            <SelectParameters>
                <asp:Parameter DefaultValue="true" Name="Status" Type="String" />
                <asp:SessionParameter Name="CartId" SessionField="cartid" Type="Int32" />
            </SelectParameters>
        </asp:SqlDataSource>            
		</table>
        <table class="table table-bordered stock-management-on">
            <tfoot>
			    <tr class="cart_total_price">
				    <td rowspan="4" colspan="3" id="cart_voucher" class="cart_voucher"></td>
					<td colspan="3" class="text-right">Total products</td>
					<td colspan="2" class="price" id="total_product"><asp:TextBox ID="TextBox1" runat="server" ReadOnly="True">0</asp:TextBox></td>
				</tr>				
                <tr class="cart_total_price">
					<td colspan="3" class="total_price_container text-right">
						<span>Total Amount</span>                        
					</td>
					<td colspan="2" class="price" id="total_price_container">
						<span id="total_price"><asp:TextBox ID="TextBox2" runat="server" ReadOnly="True">0</asp:TextBox></span>
					</td>
				</tr>
                 
			</tfoot>
        </table>
	    </div> 																				
		<div id="HOOK_SHOPPING_CART"></div>
        <asp:Literal ID="Literal1" runat="server"></asp:Literal>
	    <p class="cart_navigation clearfix">		
		    <a href="Default.aspx" class="button-exclusive btn btn-default" title="Continue shopping">
			    <i class="fa fa-chevron-left left"></i>Continue shopping
		    </a>
            <asp:Button ID="Button1" runat="server" Text="Proceed to checkout" height="32px"               
             cssclass="button-exclusive btn btn-default" onclick="Button1_Click1" />
			<%--<a  href="UserLogin.aspx"  title="Proceed to checkout" class="button-exclusive btn btn-default">
				<span>Proceed to checkout<i class="fa fa-chevron-right right"></i></span>
			</a>--%>
		</p>
	    <div class="clear"></div>
	</div></div></div></div>
</asp:Content>

